// Outfit No. 1 Models
// Model 1.3 - Scooter - Roller
// Alan Jardine, Kintore
// Uses Object Bender from Chris Colefax to form curved plates
// Version 0 - Started - 2000-10-16
// Version 2 - Scooter Body Complete - 2000-10-21
// Version 3 - Complete - 2000-10-22
// Version 3 - Scooter made into an Include File - 2001-03-04

// Parts List - included for the record and as a possible future way of parameterising
// Meccano.inc to reduce parse time


// Qty.  2 of Part   5
// Qty.  4 of Part  10
// Qty.  1 of Part  11
// Qty.  4 of Part  12
// Qty.  1 of Part  16
// Qty.  1 of Part  17
// Qty.  1 of Part  18b
// Qty.  2 of Part  22
// Qty.  4 of Part  35
// Qty. 22 of Part  37a
// Qty. 21 of Part  37b
// Qty.  6 of Part  38
// Qty.  2 of Part  48a
// Qty.  2 of Part  90a
// Qty.  2 of Part 126
// Qty.  2 of Part 126a
// Qty.  2 of Part 142c
// Qty.  1 of Part 193
// Qty.  2 of Part 194

//////////////////////////////////////////////////////////
//
// Start of logic to allow selection of Part Types (to reduce parse time)
//
#declare True  = 1;
#declare False = 0;
#declare UseStrips = True;
#declare UseGirders = False;
#declare UseBrackets = True;
#declare UseRods = True;
#declare UseMetalPulleys = True;

#declare Scooter = 

union { // Scooter
       union { // Body
              union { // Right Side Frame
                     object {Part48a translate 0.125*z}
                     union { // Side Panel 
                            object {Part126a}
                            object {Part37x rotate 180*x translate 0.5*x}
                            rotate 90*z translate 0.5*y
                           } 
                            object {Part12 rotate 90*z rotate -90*x translate <0,1.25,-0.0625>} // Top Bracket
                     translate 0.75*z
                    } 
              union { // Left Side Frame
                     object {Part48a rotate 180*x translate -0.125*z}
                     union { // Side Panel 
                            object {Part126a}
                            object {Part37x rotate  0*x translate 0.5*x}
                            rotate 90*z translate 0.5*y
                           }
                            object {Part12 rotate 90*z rotate 180*x translate <0,1.25,0.0625>} // Top Bracket  
                     translate -0.75*z
                    } 
              
              union { // Saddle Assembly
                     object {Part126 rotate 180*y}
                     object {Part37x translate -0.325*y}
                     object {Part10 rotate -90*z translate <0,-0,0.0125>}
                     rotate 90*y rotate -90*z
                     translate <-0.25,1.25,0>
                    }
              
              
              union { // Front Trunnion and Steering Axle
                     object {Part126 rotate 90*x}
                     object {Part37x translate <-0.5,-0.25,0>}
                     object {Part37x translate < 0.5,-0.25,0>}
                     object {Part37y rotate 90*x translate -0.75*z} // Steering Axle
                     rotate 90*y translate <-1.325,0.25,0>
                    } 
             // Rear Axle, Wheel & Tyre
             union {
                    object {Part17}
                    object {Part22 rotate  90*y}
                    object {Part142c rotate <90,90,0>}
                    rotate 90*y                                             // Possible Animation variable
                               
                   }         
             #declare Fairing = // for Model 1.1 Scooter
                  union {
                         object {Part194}
                         object {Part38 rotate 90*y translate <-1,0.5,0>}
                         object {Part38 rotate 90*y translate <-1,0,0>}
                         object {Part38 rotate 90*y translate <-1,-0.5,0>}
                         object {Part38 rotate 90*y translate <1,0.5,0>}
                         object {Part38 rotate 90*y translate <1,-0.5,0>}
                         object {Part37x translate <-1,0.5,0>}
                         object {Part37x translate <-1,0,0>}
                         object {Part37x translate <-1,-0.5,0>}
                         object {Part37x translate <1,0.5,0>}
                         object {Part37x translate <1,-0.5,0>}
                        } 
                  
             #declare bend_object  = object {Fairing rotate 90*x translate <1,1.325,0>}
             #declare object_axis1 = <-0.25,1.325,0>;
             #declare object_axis2 = < 2.25,1.325,0>;
             #declare bend_start = 0.05;
             #declare bend_finish = 0.95;
             #declare bend_angle = 90;
             #declare bend_smoothness = 100;
             #declare bend_direction = -y;   
             #include "C:\BigBoyD\Alans POV Scenes\Bend.inc"                                                   
            } // End of Body  
            
     union {// Steering column & Front Wheel
            
                        
             
            union { // Windscreen & Front Mudguard Assembly
                   object {Part90a rotate -15*z translate  0.275*z}
                   object {Part90a rotate -15*z translate -0.275*z}
                   #declare Mudscreen = // for Model 1.1 Scooter
                   union {
                         object {Part194}
                         object {Part38 rotate 90*y translate <-1,0,0>}
                         object {Part38 rotate 90*y translate <-0.5,0.5,0>}
                         object {Part38 rotate 90*y translate <-0.5,-0.5,0>}
                         object {Part37x translate <-1,0,0>}
                         object {Part37x translate <-0.5,0.5,0>}
                         object {Part37x translate <-0.5,-0.5,0>}
                         object {Part193 translate <-2,0,0.0125>} // Windscreen
                        } 
                  
                   #declare bend_object  = object {Mudscreen rotate -90*x translate <0.5,1.225,0>}
                   #declare object_axis1 = <-1.75,1.225,0>;
                   #declare object_axis2 = < 2.75,1.225,0>;
                   #declare bend_start = 0.4;
                   #declare bend_finish = 1;
                   #declare bend_angle = 100;
                   #declare bend_smoothness = 100;
                   #declare bend_direction = -y;   
                   #include "C:\BigBoyD\\Alans POV Scenes\Bend.inc"  
                  union {
                         union {
                                object {Part11 rotate 90*z}
                                object {Part10 rotate 180*z translate <0.25,0,-0.0125>}
                                object {Part37x}
                                rotate -74*y
                               } 
                         union {
                                object {Part5}
                                object {Part37x translate -0.5*x}
                                object {Part37x translate  0.5*x}
                                rotate 90*x translate <0.5,0.2625,0>
                               }
                         union {
                                object {Part5}
                                object {Part37x translate -0.5*x}
                                object {Part37x translate  0.5*x}
                                rotate -90*x translate <0.5,-0.2625,0>
                               }
                         union {
                               object {Part16}
                               object {Part35 translate -0.4*x}
                               object {Part35 translate  0.4*x}
                               rotate 90*z translate 1.5*x
                               }
                         rotate 90*x rotate 196*z translate <0.85,1.95,0>     
                        }
                  }      
            rotate -125*z translate <-3.75,2,0>
       
           
           } // End of Steering column
           union { // Front Axle, Wheel & Tyre
                    object {Part18b}
                    object {Part22 rotate  90*y translate -0.125*x}
                    object {Part142c rotate <90,90,0> translate -0.125*x}
                    union {
                           object {Part10}
                           object {Part37x translate 0.25*x}
                           object {Part38 rotate 90*y translate <0.25,0,-0.05>}
                           rotate 90*y rotate 180*z rotate 30*x translate <0.25,0.1325,-0.25>
                         } 
                    union {
                           object {Part10}
                           object {Part37x translate 0.25*x}
                           object {Part38 rotate 90*y translate <0.25,0,-0.05>}
                           rotate 90*y rotate 0*z rotate 30*x translate <-0.25,0.125,-0.25>
                         } 
                   rotate 90*y                                          
                   translate <-3.125,0,0>            
                   }   

} // End of Scooter
